//
//  CRGraphicsObject.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRGraphicsObjectBase.h"

@class CRGraphicsObjectRotator;

///////////////////////////////////////////////////////////////////////////////////////////////////
// Graphics object: a complex thats represents the bounds of an object. Stores object space rect
// safe rect etc. and represents it with a window rect, supports rotation, moving and resize
///////////////////////////////////////////////////////////////////////////////////////////////////
typedef enum {
	CRNone			= 0x00,
	CRRotator		= 0x01,
	CRControlPoints	= 0x02,
	
	CRAll			= CRRotator | CRControlPoints,
} CRGraphicsObjectStyle;

@interface CRGraphicsObject : CRGraphicsObjectBase
{
	CRGraphicsObjectStyle		style;
	NSArray*					controlPoints;
	CRGraphicsObjectRotator*	rotator;
}

@property (nonatomic, readonly) CRGraphicsObjectRotator* rotator;

- (id)initWithFrame:(NSRect)frameRect style:(CRGraphicsObjectStyle)aStyle;

// auxilliary
- (Class)controlPointClass;
- (BOOL)wantsRotator;
- (BOOL)wantsControlPoints;
- (void)updateRotator;

// frame replacement, deals with center rotation automatically
- (NSRect)graphicsRect;
- (void)setGraphicsRect:(NSRect)rect;

// frameRotation replacement, deals with frame automatically
- (CGFloat)centerRotation;
- (void)setCenterRotation:(CGFloat)anAngle;

@end